#ifndef __CLatchingButton__
#define __CLatchingButton__

#include "CControl.hpp"
using Exponent::GUI::Controls::CControl;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @interface CLatchingButton CLatchingButton.hpp
			 * @brief A button that changes state on each click of the mouse
			 *
			 * @date 28/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CLatchingButton.hpp,v 1.7 2007/02/08 21:07:54 paul Exp $
			 */
			class CLatchingButton : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================
		
			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 */
				CLatchingButton(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CLatchingButton();

//	===========================================================================

				/**
				 * Set the vlaue of the control
				 * @param value In range of 0 - 1 with >= 0.5 Being on
				 */
				virtual void setValue(const double value);

				/**
				 * Is the button on or off?
				 * @retval bool True if button is on, false otheriwse
				 */
				virtual bool isOn() const { return m_state; }
				
				/**
				 * Should we use cursor change?
				 * @param use If true then when mouse over occurs mouse is changed to hand cursor
				 * @note Not recommended on mac, cos it looks messy!
				 */
				virtual void useCursorChange(const bool use = true) { m_cursorChange = use; }

//	===========================================================================

				/**
				 * Draw the control
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event);

				/**
				 * Handle mouse movement
				 * @param event The event to handle
				 */
				virtual void handleMouseMovement(CMouseEvent &event);

//	===========================================================================

				/**
				 * Set the off image
				 * @param theImage The image to use when the button is turned off
				 */
				virtual void setDownImage(IImage *theImage);

				/**
				 * Set the label text
				 * @param text The text to display on the button if there is no image
				 */
				void setLabelText(const CString &text) { m_labelText = text; }

//	===========================================================================

			protected:

//	===========================================================================

				IImage *m_downImage;	/**< The off image */
				bool m_state;			/**< The current state (on or off) */
				bool m_cursorChange;	/**< Should the cursor change */
				CString m_labelText;	/**< Text drawn on the face of the button if no image is set */
			};
		}
	}
}
#endif	// End of CLatchingButton.hpp